/*
 * Copyright 2022 The Modelbox Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MODELARTS_UTILS_H_
#define MODELARTS_UTILS_H_

#include <iostream>
#include <memory>

namespace modelarts {

std::string DateTimeToUTCString(time_t time);

time_t DateTimeFromUTCString(const std::string &time);

std::string DataMasking(const std::string &data);

bool IsExpire(const std::string &expire);

}  // namespace modelarts

#endif  // MODELARTS_UTILS_H_